<?php include __DIR__.'/header.php'; ?>
<div class="p-4 p-md-5 mb-4 bg-body-tertiary rounded-3">
  <div class="container-fluid py-5">
    <h1 class="display-5 fw-bold">Camera giám sát - Lắp đặt nhanh, giá tốt</h1>
    <p class="col-md-8 fs-5">Chúng tôi cung cấp giải pháp an ninh toàn diện: Hikvision, Dahua, Imou... Bảo hành chính hãng.</p>
    <a class="btn btn-primary btn-lg" href="/san-pham">Xem sản phẩm</a>
  </div>
</div>

<h2 class="mb-3">Sản phẩm mới</h2>
<div class="row g-3">
<?php foreach($latest_products as $p): ?>
  <div class="col-6 col-md-3">
    <div class="card h-100">
      <img class="card-img-top" src="<?= e($p['image'] ?: '/assets/img/noimg.png') ?>" alt="<?= e($p['name']) ?>">
      <div class="card-body">
        <h3 class="h6 card-title"><a href="/san-pham/<?= e($p['slug']) ?>" class="stretched-link text-decoration-none"><?= e($p['name']) ?></a></h3>
        <p class="mb-0 fw-semibold text-primary"><?= number_format($p['price']) ?> đ</p>
      </div>
    </div>
  </div>
<?php endforeach; ?>
</div>

<h2 class="mt-5 mb-3">Bài viết mới</h2>
<div class="row g-3">
<?php foreach($latest_posts as $post): ?>
  <div class="col-md-4">
    <div class="card h-100">
      <div class="card-body">
        <h3 class="h5"><a class="text-decoration-none" href="/bai-viet/<?= e($post['slug']) ?>"><?= e($post['title']) ?></a></h3>
        <p><?= e(mb_strimwidth(strip_tags($post['content']),0,140,'…','UTF-8')) ?></p>
      </div>
    </div>
  </div>
<?php endforeach; ?>
</div>
<?php include __DIR__.'/footer.php'; ?>
