<?php
include __DIR__.'/partials/header.php';
require __DIR__ . '/../core/db.php';
require __DIR__ . '/../core/helpers.php';
require __DIR__ . '/../core/csrf.php'; csrf_check();

$action = $_GET['action'] ?? 'list';

if ($action === 'save' && $_SERVER['REQUEST_METHOD']==='POST'){
    $id = $_POST['id'] ?? null;
    $name = trim($_POST['name'] ?? '');
    $slug = $_POST['slug'] ? trim($_POST['slug']) : slugify($name);
    $price = (int)($_POST['price'] ?? 0);
    $short_desc = $_POST['short_desc'] ?? '';
    $description = $_POST['description'] ?? '';
    $image = $_POST['image'] ?? '';
    if($id){
        $stmt = $pdo->prepare("UPDATE products SET name=?, slug=?, price=?, short_desc=?, description=?, image=? WHERE id=?");
        $stmt->execute([$name,$slug,$price,$short_desc,$description,$image,$id]);
    }else{
        $stmt = $pdo->prepare("INSERT INTO products(name,slug,price,short_desc,description,image) VALUES(?,?,?,?,?,?)");
        $stmt->execute([$name,$slug,$price,$short_desc,$description,$image]);
    }
    header('Location: /admin/products.php'); exit;
}
if ($action === 'delete' && isset($_GET['id'])){
    $stmt = $pdo->prepare("DELETE FROM products WHERE id=?");
    $stmt->execute([$_GET['id']]);
    header('Location: /admin/products.php'); exit;
}
if ($action === 'edit'){
    $id = $_GET['id'] ?? null;
    $item = ['id'=>'','name'=>'','slug'=>'','price'=>0,'short_desc'=>'','description'=>'','image'=>''];
    if($id){
        $stmt = $pdo->prepare("SELECT * FROM products WHERE id=?");
        $stmt->execute([$id]);
        $item = $stmt->fetch() ?: $item;
    }
    ?>
    <h1 class="h4 mb-3"><?= $item['id'] ? 'Sửa sản phẩm' : 'Thêm sản phẩm' ?></h1>
    <form method="post" action="/admin/products.php?action=save">
      <?php csrf_field(); ?>
      <input type="hidden" name="id" value="<?= e($item['id']) ?>">
      <div class="mb-3"><label class="form-label">Tên sản phẩm</label><input name="name" class="form-control" value="<?= e($item['name']) ?>" required></div>
      <div class="mb-3"><label class="form-label">Slug (SEO URL)</label><input name="slug" class="form-control" value="<?= e($item['slug']) ?>"></div>
      <div class="mb-3"><label class="form-label">Giá</label><input name="price" type="number" class="form-control" value="<?= e($item['price']) ?>"></div>
      <div class="mb-3"><label class="form-label">Ảnh (URL)</label><input name="image" class="form-control" value="<?= e($item['image']) ?>"></div>
      <div class="mb-3"><label class="form-label">Mô tả ngắn</label><textarea name="short_desc" class="form-control" rows="3"><?= e($item['short_desc']) ?></textarea></div>
      <div class="mb-3"><label class="form-label">Mô tả chi tiết (HTML)</label><textarea name="description" class="form-control" rows="8"><?= e($item['description']) ?></textarea></div>
      <button class="btn btn-primary">Lưu</button>
      <a class="btn btn-outline-secondary" href="/admin/products.php">Hủy</a>
    </form>
    <?php
    include __DIR__.'/partials/footer.php'; exit;
}

$rows = $pdo->query("SELECT * FROM products ORDER BY id DESC")->fetchAll();
?>
<h1 class="h4 mb-3">Sản phẩm <a class="btn btn-sm btn-primary" href="/admin/products.php?action=edit">Thêm mới</a></h1>
<table class="table table-striped align-middle">
  <thead><tr><th>ID</th><th>Tên</th><th>Giá</th><th>Slug</th><th width="150"></th></tr></thead>
  <tbody>
  <?php foreach($rows as $r): ?>
    <tr>
      <td><?= e($r['id']) ?></td>
      <td><?= e($r['name']) ?></td>
      <td><?= number_format($r['price']) ?> đ</td>
      <td><?= e($r['slug']) ?></td>
      <td class="text-end">
        <a class="btn btn-sm btn-outline-secondary" href="/admin/products.php?action=edit&id=<?= e($r['id']) ?>">Sửa</a>
        <a class="btn btn-sm btn-outline-danger" onclick="return confirm('Xóa sản phẩm này?')" href="/admin/products.php?action=delete&id=<?= e($r['id']) ?>">Xóa</a>
      </td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
<?php include __DIR__.'/partials/footer.php'; ?>
