<?php
$config = require __DIR__ . '/../core/config.php';
require __DIR__ . '/../core/db.php';
require __DIR__ . '/../core/helpers.php';
session_start();

$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$uri = rtrim($uri, '/');
if ($uri === '') $uri = '/';

// Load homepage data
if ($uri === '/' ) {
    $latest_products = $pdo->query("SELECT id, name, slug, price, image FROM products ORDER BY id DESC LIMIT 8")->fetchAll();
    $latest_posts = $pdo->query("SELECT id, title, slug, content, created_at FROM posts ORDER BY id DESC LIMIT 6")->fetchAll();
    $meta_title = 'Trang chủ';
    include __DIR__ . '/templates/home.php';
    exit;
}

// Product listing
if ($uri === '/san-pham') {
    $products = $pdo->query("SELECT id, name, slug, price, image FROM products ORDER BY id DESC")->fetchAll();
    $meta_title = 'Sản phẩm';
    include __DIR__ . '/templates/product_list.php';
    exit;
}

// Product detail by slug
if (preg_match('#^/san-pham/([\w\-]+)$#',$uri,$m)) {
    $slug = $m[1];
    $stmt = $pdo->prepare("SELECT * FROM products WHERE slug=? LIMIT 1");
    $stmt->execute([$slug]);
    if(!$product = $stmt->fetch()){ http_response_code(404); include __DIR__.'/templates/404.php'; exit; }
    $meta_title = $product['name'];
    $meta_desc = strip_tags($product['short_desc']);
    include __DIR__ . '/templates/product_detail.php';
    exit;
}

// Blog listing
if ($uri === '/bai-viet') {
    $posts = $pdo->query("SELECT id, title, slug, content, created_at FROM posts ORDER BY id DESC")->fetchAll();
    $meta_title = 'Bài viết';
    include __DIR__ . '/templates/blog_list.php';
    exit;
}

// Blog detail by slug
if (preg_match('#^/bai-viet/([\w\-]+)$#',$uri,$m)) {
    $slug = $m[1];
    $stmt = $pdo->prepare("SELECT * FROM posts WHERE slug=? LIMIT 1");
    $stmt->execute([$slug]);
    if(!$post = $stmt->fetch()){ http_response_code(404); include __DIR__.'/templates/404.php'; exit; }
    $meta_title = $post['title'];
    $meta_desc = mb_strimwidth(strip_tags($post['content']),0,160,'…','UTF-8');
    include __DIR__ . '/templates/blog_detail.php';
    exit;
}

http_response_code(404);
include __DIR__.'/templates/404.php';
