<?php
function asset($path) {
    global $config;
    return rtrim($config['app']['base_url'],'/') . '/assets/' . ltrim($path,'/');
}
function url($path = '') {
    global $config;
    return rtrim($config['app']['base_url'],'/') . '/' . ltrim($path,'/');
}
function e($str){ return htmlspecialchars((string)$str, ENT_QUOTES, 'UTF-8'); }
function slugify($text){
    $text = iconv('UTF-8', 'ASCII//TRANSLIT//IGNORE', $text);
    $text = preg_replace('~[^\pL\d]+~u', '-', $text);
    $text = trim($text, '-');
    $text = preg_replace('~[^-\w]+~', '', $text);
    $text = strtolower($text);
    return $text ?: 'n-a';
}
function paginate($total,$per,$page){
    $pages = max(1, ceil($total/$per));
    return ['pages'=>$pages,'current'=>max(1,min($page,$pages))];
}
