<?php
include __DIR__.'/partials/header.php';
require __DIR__ . '/../core/db.php';
require __DIR__ . '/../core/csrf.php'; csrf_check();

if($_SERVER['REQUEST_METHOD']==='POST'){
    foreach(['site_name','site_title','site_description','site_keywords'] as $k){
        $v = $_POST[$k] ?? '';
        $stmt = $pdo->prepare("UPDATE settings SET value=? WHERE `key`=?");
        $stmt->execute([$v,$k]);
    }
    echo '<div class="alert alert-success">Đã lưu.</div>';
}
$settings = $pdo->query("SELECT `key`,`value` FROM settings")->fetchAll();
$current = array_column($settings,'value','key');
?>
<h1 class="h4 mb-3">Cài đặt</h1>
<form method="post">
  <?php csrf_field(); ?>
  <div class="mb-3"><label class="form-label">Tên site</label><input name="site_name" class="form-control" value="<?= e($current['site_name'] ?? '') ?>"></div>
  <div class="mb-3"><label class="form-label">Tiêu đề trang</label><input name="site_title" class="form-control" value="<?= e($current['site_title'] ?? '') ?>"></div>
  <div class="mb-3"><label class="form-label">Mô tả</label><textarea name="site_description" class="form-control" rows="3"><?= e($current['site_description'] ?? '') ?></textarea></div>
  <div class="mb-3"><label class="form-label">Từ khóa</label><input name="site_keywords" class="form-control" value="<?= e($current['site_keywords'] ?? '') ?>"></div>
  <button class="btn btn-primary">Lưu</button>
</form>
<?php include __DIR__.'/partials/footer.php'; ?>
