<?php
include __DIR__.'/partials/header.php';
require __DIR__ . '/../core/db.php';
require __DIR__ . '/../core/helpers.php';
require __DIR__ . '/../core/csrf.php'; csrf_check();

$action = $_GET['action'] ?? 'list';

if ($action === 'save' && $_SERVER['REQUEST_METHOD']==='POST'){
    $id = $_POST['id'] ?? null;
    $title = trim($_POST['title'] ?? '');
    $slug = $_POST['slug'] ? trim($_POST['slug']) : slugify($title);
    $content = $_POST['content'] ?? '';
    if($id){
        $stmt = $pdo->prepare("UPDATE posts SET title=?, slug=?, content=? WHERE id=?");
        $stmt->execute([$title,$slug,$content,$id]);
    }else{
        $stmt = $pdo->prepare("INSERT INTO posts(title,slug,content,created_at) VALUES(?,?,?,NOW())");
        $stmt->execute([$title,$slug,$content]);
    }
    header('Location: /admin/posts.php'); exit;
}
if ($action === 'delete' && isset($_GET['id'])){
    $stmt = $pdo->prepare("DELETE FROM posts WHERE id=?");
    $stmt->execute([$_GET['id']]);
    header('Location: /admin/posts.php'); exit;
}
if ($action === 'edit'){
    $id = $_GET['id'] ?? null;
    $item = ['id'=>'','title'=>'','slug'=>'','content'=>''];
    if($id){
        $stmt = $pdo->prepare("SELECT * FROM posts WHERE id=?");
        $stmt->execute([$id]);
        $item = $stmt->fetch() ?: $item;
    }
    ?>
    <h1 class="h4 mb-3"><?= $item['id'] ? 'Sửa bài viết' : 'Thêm bài viết' ?></h1>
    <form method="post" action="/admin/posts.php?action=save">
      <?php csrf_field(); ?>
      <input type="hidden" name="id" value="<?= e($item['id']) ?>">
      <div class="mb-3"><label class="form-label">Tiêu đề</label><input name="title" class="form-control" value="<?= e($item['title']) ?>" required></div>
      <div class="mb-3"><label class="form-label">Slug (SEO URL)</label><input name="slug" class="form-control" value="<?= e($item['slug']) ?>"></div>
      <div class="mb-3"><label class="form-label">Nội dung (HTML)</label><textarea name="content" class="form-control" rows="10"><?= e($item['content']) ?></textarea></div>
      <button class="btn btn-primary">Lưu</button>
      <a class="btn btn-outline-secondary" href="/admin/posts.php">Hủy</a>
    </form>
    <?php
    include __DIR__.'/partials/footer.php'; exit;
}

$rows = $pdo->query("SELECT * FROM posts ORDER BY id DESC")->fetchAll();
?>
<h1 class="h4 mb-3">Bài viết <a class="btn btn-sm btn-primary" href="/admin/posts.php?action=edit">Thêm mới</a></h1>
<table class="table table-striped align-middle">
  <thead><tr><th>ID</th><th>Tiêu đề</th><th>Slug</th><th>Ngày</th><th width="150"></th></tr></thead>
  <tbody>
  <?php foreach($rows as $r): ?>
    <tr>
      <td><?= e($r['id']) ?></td>
      <td><?= e($r['title']) ?></td>
      <td><?= e($r['slug']) ?></td>
      <td><?= date('d/m/Y', strtotime($r['created_at'])) ?></td>
      <td class="text-end">
        <a class="btn btn-sm btn-outline-secondary" href="/admin/posts.php?action=edit&id=<?= e($r['id']) ?>">Sửa</a>
        <a class="btn btn-sm btn-outline-danger" onclick="return confirm('Xóa bài này?')" href="/admin/posts.php?action=delete&id=<?= e($r['id']) ?>">Xóa</a>
      </td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
<?php include __DIR__.'/partials/footer.php'; ?>
